*! version 5.0
* 13 August 2018
* NIDS

* THIS IS A FOOD AND NON-FOOD EXPENDITURE DO FILE: 10 OF 14

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Food_NonFood Expenditure - Master  Food_NonFood Expenditure do file  (1 of 14).do"

*=====================================================================================================================================
* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

use "$DataOUT\tempdata8.dta", clear

**********************************************************************
***			Final Aggregation of Expenditure
**********************************************************************
*This file generates aggregate expenditure values and cleans and labels the remaining variables.
*This will leave the user with a comprehensive version of the expenditure data, which allows for detailed investigation into the different componenents
*of expenditure, as well as a look at the two different methods used (cell median and regression) to perform imputations. Analysis of this data should show
*very little difference between the aggregate figures generated by the two differnet methods

*Imputed values
egen totalexpreg = rowtotal(nfregagg fregagg)
gen annexpreg=totalexpreg*12

*Raw Values
egen totalexprough = rowtotal(totalfood nfoodtot)
replace totalexprough=. if totalexprough==0
gen annexprough=totalexprough*12

**********************************************************************
***			Final Clean Up
**********************************************************************

*Drop all variables used in Regressions
drop  house trad 
drop dwell1 dwell4-dwell9 dwell11 roof1-roof15 corru tile asb brick wall1-wall15 mud lgd38  lgd13 lgincome_pc lgincome lgd31 ///
employ fridge grants lge1_1 anychildren cell computer maxagesq pensionage adultage adults equivadult pertile valpertile 

drop  majpop maxed maxage ageunder15 hhchildren fammatric famtert famprim African Coloured Asian White westerncape easterncape ///
northerncape freestate kwazulunatal northwest gauteng mpumalanga limpopo geoarea farm traditional a3 hhincome_pc

label var totalexpreg "Total Monthly Household Expenditure using the regression method for imputations"

label var annexpreg "Total Annual Household Expenditure using the regression method for imputations"

*-----------------------------------------------------------------------------------

save "$DataOUT\tempdata9.dta", replace

